function new_plot(T_INI,X_T,Y_T,T,X_Vx_T,Y_Vx_T,VX_T,VY_T,X_V_rot,Y_V_rot,VX_V_rot,VY_V_rot,xf_V_rot,yf_V_rot,H_shearheat,eta,Lx_T,Ly_T,y_T,time,dX_ref_rot,dY_ref_rot,x_ref_T,y_ref_T,x_ref_V_rot,y_ref_V_rot)

figure(1); clf, colormap(jet)

% Modify the X Y units (from meters to km)
X_T = X_T.*1e-3;
Y_T = Y_T.*1e-3;
X_Vx_T = X_Vx_T.*1e-3;
Y_Vx_T = Y_Vx_T.*1e-3;
X_V_rot = X_V_rot.*1e-3;
Y_V_rot = Y_V_rot.*1e-3;
VX_V_rot = VX_V_rot.*1e-3;
xf_V_rot = xf_V_rot.*1e-3;
yf_V_rot = yf_V_rot.*1e-3;
Lx_T = Lx_T.*1e-3;
Ly_T = Ly_T.*1e-3;
dX_ref_rot = dX_ref_rot*1e-3;
dY_ref_rot = dY_ref_rot*1e-3;

%Temperature
subplot(211)
st  = 5;
hold on
contourf(X_T,Y_T,T-273.15,15,'w'); shading interp
% quiv = quiver(X_Vx_T(2:end,:),Y_Vx_T(2:end,:),VX_T(2:end,:),VY_T(:,2:end));
quiv = quiver(X_Vx_T(2:st:end,1:st:end),Y_Vx_T(2:st:end,1:st:end),VX_T(2:st:end,1:st:end),VY_T(1:st:end,2:st:end));
set(quiv,'linewidth',0.5,'color','k')
% Fault
%     plot(xf_V_rot(:,3:end-11),yf_V_rot(:,3:end-11),'-k','Linewidth',1.5)
plot(xf_V_rot,yf_V_rot,'-k','Linewidth',1.5)
%PLOT SETTINGS
axis equal
% text(0.8*Lx_T,1.2*max(y_T),strcat('Time = ',num2str(ceil(time./(3600*24*365*1e6))),'Myr'))
title(['Thermokinematic Model of Nappe formation; Time = ',num2str(time./(3600*24*365*1e6),2),' [Myr]'])
xlabel('Length [km]'),ylabel('Depth [km]')
axis([0 Lx_T 0 Ly_T])
%     caxis([20 620])
set(get(colorbar,'label'),'string','Temperature [C]');
hold off

subplot(212)
hold on
pcolor(X_T,Y_T,log10(eta)); shading interp; caxis([log10(1e21*exp(-3)) 21]); colorbar
%     contourf(X_T,Y_T,log10(eta),15,'w'); shading interp; colorbar
%     contourf(X_T(2:end-1,2:end-1),Y_T(2:end-1,2:end-1),H_shearheat,15,'w'); shading interp; colorbar
%     contourf(X_T,Y_T,T_INI-273.15,15,'w'); shading interp; colorbar
%     contourf(X_T,Y_T,T-T_INI,15,'w'); shading interp; colorbar
% pcolor(X_T,Y_T,(1./T-1./T_INI)); shading interp; colorbar
% contour(X_T,Y_T,(1./T-1./T_INI),[0 0],'w'); shading interp; colorbar
% ex_fun  = exp( (2e5/8.314) .* (1./T-1./T_INI) );
% ex_fun  = (2e5/8.314) .* (1./T-1./T_INI);
% ex_fun(ex_fun>0)    = 0;
% ex_fun(ex_fun<-2)   = -2;
% contourf(X_T,Y_T,(ex_fun),15,'w'); shading interp; %caxis([1e-2 1e2]); 
% colorbar
hold off
axis equal
xlabel('Length [km]'),ylabel('Depth [km]')
axis([0 Lx_T 0 Ly_T])
%     caxis([20 620])
set(get(colorbar,'label'),'string','log_{10} Viscosity [Pa s]');
title(['Viscosity field'])

set(gcf,'paperunits','normalized','position',[4.2000 190.6000 792.8000 545.6000])

drawnow
end